#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Dec 10 09:11:30 2019

@author: yannbrunel
"""

import numpy as np
import matplotlib.pyplot as plt
import random
#%%
def radioactivité(NA): #définit une fonction
    Nrestants=NA # remplace Nrestants par NA
    for i in range(0,NA): #ouvre une boucle : pour tous les atomes de NA
        if random.randint(1,50)==1: # crée une loterie sur un dé à 50 faces, si le résultat est 1
            Nrestants=Nrestants-1 # diminue de 1 le nombre d'atomes restants
    return Nrestants # retourne Nrestants

t=0
nb=100
n0=100
Nr=[] #crée une liste vide
Tr=[] #idem
while nb>0: #tant que nb est non nul
    Tr.append(t) #complète la liste Tr avec les valeurs de t
    Nr.append(nb) # complète la liste des Nr
    nb=radioactivité(nb) # applique à nb le programme précédent et on remplace nb par la nouvelle valeur après application du programme
    t=t+1 # augmente le temps
#%%
plt.plot(Tr,Nr,'r-',label='Nr(Tr)') #options de tracé
plt.legend(loc='best') 
plt.xlabel('t') ; plt.ylabel('$Nombres d atomes restants$')
plt.grid()
plt.show()
plt.figure()  
#%%
def Nthéo(u): # définit une fonction exponentielle, qui est la solution théorique du problème
    return n0*(np.exp(-u/50))

t0, tf = 0., 400. # bornes de l'intervalle de temps pour la résolution
N = 10000 # nombre de pas
t = np.linspace(t0,tf,N+1) # liste des dates pour le calcul des solutions aprochées
#%%
plt.plot(t,Nthéo(t),'b-',label='évolution théorique') #options de tracé
plt.plot(Tr,Nr,'r-',label='Nr(Tr)')
plt.legend(loc='best') 
plt.xlabel('t') ; plt.ylabel('$Nombres d atomes restants$')
plt.grid()
plt.show()
plt.figure()
#%%
# on refait la même chose pour beaucoup plus d'atomes, afin de vérifier l'influence de ce paramètre sur la pertinence de la modélisation exponentielle
t=0
mb=5000
m0=5000
Mr=[]
Tr=[]
while mb>0:
    Tr.append(t)
    Mr.append(mb)
    mb=radioactivité(mb)
    t=t+1

def Nthéo2(u):
    return m0*(np.exp(-u/50))

t0, tf = 0., 400. # bornes de l'intervalle de temps pour la résolution
N = 10000 # nombre de pas
t = np.linspace(t0,tf,N+1) # liste des dates pour le calcul des solutions aprochées

#%%  
plt.plot(t,Nthéo2(t),'b-',label='évolution théorique')
plt.plot(Tr,Mr,'r-',label='Nr(Tr)')
plt.legend(loc='best') 
plt.xlabel('t') ; plt.ylabel('$Nombres d atomes restants$')
plt.grid()
plt.show()
plt.figure()